VERSION 5.00
Begin VB.Form frmMain 
   Caption         =   "Form1"
   ClientHeight    =   3180
   ClientLeft      =   3990
   ClientTop       =   2385
   ClientWidth     =   4680
   LinkTopic       =   "Form1"
   ScaleHeight     =   3180
   ScaleWidth      =   4680
End
Attribute VB_Name = "frmMain"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
'for general purpose product independent)
Dim WithEvents mTestMenu As PSMenu32
Attribute mTestMenu.VB_VarHelpID = -1
Dim mUtility As PSUtility32
Dim mDatabase As PSSQL32
Dim mReport As PSReport32
Dim WithEvents mBiasVoltageTune As PSLEDBar32
Attribute mBiasVoltageTune.VB_VarHelpID = -1
Dim WithEvents mVirtualDevice As PSVirtualDevice32
Attribute mVirtualDevice.VB_VarHelpID = -1
Dim mIsAbortTest As Boolean
Const mstr4NewLine = vbNewLine & vbNewLine & vbNewLine & vbNewLine

'for equipment with GPIB interface (depend in testing product)
Dim WithEvents m3499A As PSGPIB32                          'Switch
Attribute m3499A.VB_VarHelpID = -1
Dim WithEvents mFluke45 As PSGPIB32                        'DVM
Attribute mFluke45.VB_VarHelpID = -1
Dim WithEvents mE3631A As PSGPIB32                         'Power Supply
Attribute mE3631A.VB_VarHelpID = -1
Dim WithEvents m33120A As PSGPIB32                         'Signal Generator
Attribute m33120A.VB_VarHelpID = -1
Dim WithEvents m53131A As PSGPIB32                         'Frequency Counter
Attribute m53131A.VB_VarHelpID = -1
Dim mIsVirtualDeviceQuit As Boolean
Public Enum TestResult
    IsFailed = False
    IsPassed = True
End Enum

Private Sub Form_Load()
'check is appliction already running?
If App.PrevInstance Then
    MsgBox "Attention! an other copy of this software is running.", vbExclamation + vbOKOnly
    End
End If
'set class objects
Set mTestMenu = New PSMenu32
Set mUtility = New PSUtility32
Set mDatabase = New PSSQL32
Set mReport = New PSReport32
Set mBiasVoltageTune = New PSLEDBar32
Set mVirtualDevice = New PSVirtualDevice32
Set m3499A = New PSGPIB32
Set mFluke45 = New PSGPIB32
Set mE3631A = New PSGPIB32
Set m33120A = New PSGPIB32
Set m53131A = New PSGPIB32

With mUtility
    'let class library know where is your applicaion path, this will helpful such add more search path _
     for looking the relevant support file
    .AppPath = App.Path
    
    'let class library know where is your desire INI files
    .INIPath = .AppPath
    
    'let class library know where is your new INI files then if class library found newer one (check file date/time not version) _
     it will be automate updating by change the existing file name. Normally new update files should keep _
     in share network drive so that you will perform update INI file from center.
    .UpdateINI "C:\_New INI"
    
    'enable the INI security check so if you set the AdminPassword property then library will automate _
     validate the INI files. It found the changed of either ATE.INI or PRODUCTS.INI the class library will show _
     the prompt for need enter the below password and do not allow to continue unless the proper password is entered. _
     Leave this property bank if you don't want enable the security check.
    .AdminPassword = "password"
    
    'then send the your software version to class library so that then put it in database, print out
    'otherwise the class library will do not known what your software version
    'this version number you can assign during you do the compile
    .WriteINI True, "ATE Configuration", "TestSoftwareVersion", _
                     App.Major & "." & App.Minor & "." & App.Revision
    .BackgroundColor = &H404040         'defalut is black color
    .ShowBackground
End With
With mTestMenu
    '.EnableTestPrompt = False          'enable/disable test prompt that generate from class library
    '.DisableGroupTestButton = True     'enable/disable operator to run test program only all test group mode _
                                         or also allow to run individual group mode
    .ShowMenu                           'show user entry from so that start the testing
    .ShowCabinet                        'if you wish to show equipment cabinet then remove this remark out
End With
DoIniEquipment                      'this method should run only one time on starting
Me.WindowState = vbMinimized
End Sub

Private Sub DoIniEquipment()
'this procedure should be done only one time on starting
'get GPIB addresses from INI

Const IsGPIBInSimulateMode = True       'change it to false for real access GPIB device
With mUtility
    'get GPIB addresses from INI, anyway you may direct assign without read from INI file
    'but you need edit then re-compile your code once whenever the address number is changed
    m3499A.DeviceName = .ReadINI(True, "GPIB Addresses", "3499A")
    mE3631A.DeviceName = .ReadINI(True, "GPIB Addresses", "E3631A")
    mFluke45.DeviceName = .ReadINI(True, "GPIB Addresses", "Fluke45")
    m33120A.DeviceName = .ReadINI(True, "GPIB Addresses", "m33120A")
    m53131A.DeviceName = .ReadINI(True, "GPIB Addresses", "m53131A")
End With
'initialize equipment and arrange the panels information and position
With m3499A             'Agilent switch
    .SimulateMode = IsGPIBInSimulateMode
    .InitCommand1 = "*RST;*CLS"
    .InitCommand2 = "DIAG:DISP:INFO ""COMPANY X"""
    .PanelHide = True   'no need to show panel
    .StatusPosition = CenterDown
    .Execute
End With
With m33120A            'Agilent Sinal Generator
    .SimulateMode = IsGPIBInSimulateMode
    .InitCommand1 = "*RST;*CLS"
    .PanelHide = True   'no need to show panel
    .Execute
End With
With mE3631A            'Agilent DC power supply
    .SimulateMode = IsGPIBInSimulateMode
    .PanelPosition = RightUp
    .InitCommand1 = "*RST;*CLS"
    .PanelStatus = "Remote"
    .PanelOption = "DC Volts"
    .BrandName = "Agilent"
    .ModelName = "E3631A"
    .CabReference = .BrandName & .ModelName
    .ReadCommand = "MEAS?"
    .ReadInterval = 250
    .ScaleFactor = 10
    .Execute
End With
With m53131A            'Frequency Counter
    .SimulateMode = IsGPIBInSimulateMode
    .PanelLeft = mE3631A.PanelLeft
    .PanelTop = mE3631A.PanelTop + mE3631A.PanelHeight
    .InitCommand1 = "*RST"
    .PanelStatus = "Remote"
    .PanelOption = "Hz"
    .BrandName = "Agilent"
    .ModelName = "53131A"
    .CabReference = .BrandName & .ModelName
    .ReadCommand = "MEAS?"
    .ReadInterval = 250
    .ScaleFactor = 1000
    .Execute
End With
With mFluke45          'Fluke 45 DVM
    .SimulateMode = IsGPIBInSimulateMode
    .PanelLeft = m53131A.PanelLeft
    .PanelTop = m53131A.PanelTop + m53131A.PanelHeight
    .InitCommand1 = "*RST;*CLS"
    .InitCommand2 = "RANGE 3;RATE F"
    .PanelStatus = "Remote"
    .PanelOption = "DC Volts"
    .BrandName = "Fluke"
    .ModelName = "45"
    .CabReference = "This is my device"
    .StatusLeft = .PanelLeft
    .StatusTop = .PanelTop + .PanelHeight
    .DigitColor = &H80FF&
    .ReadCommand = "MEAS?"
    .ReadInterval = 250
    '.ScaleFactor = 10
    .Execute
End With
End Sub

Private Sub Form_Resize()
Me.Hide                                 'then hide the main form (normally we need it for keep the test code _
                                         unless you need do anything else
End Sub

Private Sub Form_Unload(Cancel As Integer)
'destroy object and clear them out from memeoy
Set mTestMenu = Nothing
Set mUtility = Nothing
Set mDatabase = Nothing
Set mReport = Nothing
Set mBiasVoltageTune = Nothing
Set mVirtualDevice = Nothing
Set m3499A = Nothing
Set mFluke45 = Nothing
Set mE3631A = Nothing
Set m33120A = Nothing
Set m53131A = Nothing
End Sub

Private Sub mBiasVoltageTune_ValueChanged(ByVal Value As Double, ByVal IsPassed As Boolean)
With mVirtualDevice
    If IsPassed Then
        .Caption = vbCrLf & "Value In Range so please click OK."
    Else
        .Caption = vbCrLf & "Value Out of Range."
    End If
    .SendValue Value, 3
End With
End Sub

Private Sub mTestMenu_AbortClick()
mIsAbortTest = True
mBiasVoltageTune.Hide
mTestMenu.ShowPassFail
mTestMenu.StopTest
End Sub

Private Sub mTestMenu_AllTestClick(ByVal ProductName As String)
'let operator entry test information such UUT serial number and so on before do all test
If Not mTestMenu.ShowUserEntry Then
    mTestMenu.StopTest
    Exit Sub
Else
    'opearator may changed product during do enter test information
    'if single product test in INI file the below line may ignore
    ProductName = mTestMenu.TestProduct
End If
'reset test abort flag
mIsAbortTest = False
mTestMenu.HidePassFail
Select Case ProductName
    Case "Template Product"
        If DoGroupATest("Group A Test", "Set_Ohm") = IsFailed And Not mIsAbortTest _
           Then GoTo StopAllTest
        
        If mIsAbortTest Then GoTo StopAllTest
        DoGroupBTest "Group B Test", "Set_Curr"
        
        If mIsAbortTest Then GoTo StopAllTest
        DoGroupCTest "Group C Test"
        
        If mIsAbortTest Then GoTo StopAllTest
        DoGroupDTest "Group D Test"
        
        If mIsAbortTest Then GoTo StopAllTest
        DoGroupETest "Group E Test", "Set_Volt"
        
        If mIsAbortTest Then GoTo StopAllTest
        DoGroupFTest "Group F Test", "Set_Volt"
        
        If mIsAbortTest Then GoTo StopAllTest
        DoGroupGTest "Group G Test"
    Case "X1 Dummy Product"
        If DoContinuityTest("Continuity Test") = IsFailed And Not mIsAbortTest _
           Then GoTo StopAllTest
        
        If mIsAbortTest Then GoTo StopAllTest
        DoCurrentTest "Current Test"
        
        If mIsAbortTest Then GoTo StopAllTest
        DoGain1MHzTest "Gain @1MHz Test"
        
        If mIsAbortTest Then GoTo StopAllTest
        DoFreqResponseTest "Frequency Response Test"
        
        If mIsAbortTest Then GoTo StopAllTest
        DoBiasVoltageTest "Bias Voltage Test"
        
        If mIsAbortTest Then GoTo StopAllTest
        DoTempFullLoadTest "Temp Full Load Test"
End Select

'test is done then write test data into database and print out report
mDatabase.WriteDatabase , , msAccess, App.Path & "\TestData.MDB"    'do not use DatabaseName from ATE.INI
'mDatabase.WriteDatabase ,  ,  msSQLServer
mReport.PrintReport

StopAllTest:
mTestMenu.ShowPassFail
mTestMenu.StopTest
DoBackInitialState              'this procedure should include shutdown any power supply (get to safe state)
End Sub

Private Sub mTestMenu_ExitClick()
Unload Me
End
End Sub

Private Sub mTestMenu_GroupTestClick(ByVal ProductName As String, ByVal GroupName As String)
mIsAbortTest = False
Select Case ProductName
    Case "Template Product"
        Select Case GroupName
            Case "Group A Test"
                DoGroupATest GroupName, "Set_Ohm"
            Case "Group B Test"
                DoGroupBTest GroupName, "Set_Curr"
            Case "Group C Test"
                DoGroupCTest GroupName
            Case "Group D Test"
                DoGroupDTest GroupName
            Case "Group E Test"
                DoGroupETest GroupName, "Set_Volt"
            Case "Group F Test"
                DoGroupFTest GroupName, "Set_Volt"
            Case "Group G Test"
                DoGroupGTest GroupName
        End Select
    Case "X1 Dummy Product"
        Select Case GroupName
            Case "Continuity Test"
                DoContinuityTest GroupName
            Case "Current Test"
                DoCurrentTest GroupName
            Case "Gain @1MHz Test"
                DoGain1MHzTest GroupName
            Case "Frequency Response Test"
                DoFreqResponseTest GroupName
            Case "Bias Voltage Test"
                DoBiasVoltageTest GroupName
            Case "Temp Full Load Test"
                DoTempFullLoadTest GroupName
        End Select
End Select
mTestMenu.StopTest
DoBackInitialState              'this procedure should include shutdown any power supply (get to safe state)
End Sub

Private Function DoContinuityTest(ByVal GroupName As String, _
                                  Optional IsNeedPowerOn As Boolean = False) As TestResult
Dim varTestResults As Variant
'default is passed unless found any failure then set to failed
DoContinuityTest = IsPassed

With mTestMenu
    varTestResults = "Testing"
    .SendData GroupName, "Main Power I/P", varTestResults   'make testing hi-light
    '====================start your code to test this parameter here=====================
    mUtility.Delay 1                'just delay, commant it out and put your code instead
    '***put your code here***
    '***put your code here***
    varTestResults = "Pass"         'put the test result to variable
    'then send test output to menu
    If Not .SendData(GroupName, "Main Power I/P", varTestResults) Then
        DoContinuityTest = IsFailed
        Exit Function               'abort test right away if it failed (if needed)
    End If
    '====================================================================================
    
    If mIsAbortTest Then Exit Function
    varTestResults = "Testing"
    .SendData GroupName, "Output Slot A", varTestResults
     '====================start your code to test this parameter here=====================
    mUtility.Delay 1                'just delay, commant it out and put your code instead
    varTestResults = "Pass"         'put the test result to variable
    'then send test output to menu
    If Not .SendData(GroupName, "Output Slot A", varTestResults) Then DoContinuityTest = IsFailed
    '====================================================================================
    
    If mIsAbortTest Then Exit Function
    varTestResults = "Testing"
    .SendData GroupName, "Output Slot B", varTestResults
     '====================start your code to test this parameter here=====================
    mUtility.Delay 1                'just delay, commant it out and put your code instead
    varTestResults = "Pass"         'put the test result to variable
    'then send test output to menu
    If Not .SendData(GroupName, "Output Slot B", varTestResults) Then DoContinuityTest = IsFailed
    '====================================================================================
    
    If mIsAbortTest Then Exit Function
    varTestResults = "Testing"
    .SendData GroupName, "Output Slot C", varTestResults
     '====================start your code to test this parameter here=====================
    mUtility.Delay 1                'just delay, commant it out and put your code instead
    varTestResults = "Pass"         'put the test result to variable
    'then send test output to menu
    If Not .SendData(GroupName, "Output Slot C", varTestResults) Then DoContinuityTest = IsFailed
    '====================================================================================
    
    If mIsAbortTest Then Exit Function
    varTestResults = "Testing"
    .SendData GroupName, "Output Slot D", varTestResults
     '====================start your code to test this parameter here=====================
    mUtility.Delay 1                'just delay, commant it out and put your code instead
    varTestResults = "Pass"         'put the test result to variable
    'then send test output to menu
    If Not .SendData(GroupName, "Output Slot D", varTestResults) Then DoContinuityTest = IsFailed
    '====================================================================================
End With
End Function

Private Function DoCurrentTest(ByVal GroupName As String, _
                              Optional IsNeedPowerOn As Boolean = False) As TestResult
Dim varTestResults As Variant
'default is passed unless found any failure then set to failed
DoCurrentTest = IsPassed

With mTestMenu
    varTestResults = "Testing"
    .SendData GroupName, "Q1 Current", varTestResults  'make testing hi-light
    '====================start your code to test this parameter here=====================
    mUtility.Delay 1                'just delay, commant it out and put your code instead
    '***put your code here***
    '***put your code here***
    varTestResults = "112"         'put the test result to variable
    'then send test output to menu
    If Not .SendData(GroupName, "Q1 Current", varTestResults) Then DoCurrentTest = IsFailed
    
    If mIsAbortTest Then Exit Function
    varTestResults = "Testing"
    .SendData GroupName, "Q2 Current", varTestResults   'make testing hi-light
     '====================start your code to test this parameter here=====================
    mUtility.Delay 1                'just delay, commant it out and put your code instead
    varTestResults = "131"         'put the test result to variable
    'then send test output to menu
    If Not .SendData(GroupName, "Q2 Current", varTestResults) Then DoCurrentTest = IsFailed
    '====================================================================================
    
    If mIsAbortTest Then Exit Function
    varTestResults = "Testing"
    .SendData GroupName, "Q3 Current", varTestResults
     '====================start your code to test this parameter here=====================
    mUtility.Delay 1                'just delay, commant it out and put your code instead
    varTestResults = "142"         'put the test result to variable
    'then send test output to menu
    If Not .SendData(GroupName, "Q3 Current", varTestResults) Then DoCurrentTest = IsFailed
    '====================================================================================
    
    If mIsAbortTest Then Exit Function
    varTestResults = "Testing"
    .SendData GroupName, "Q4 Current", varTestResults
     '====================start your code to test this parameter here=====================
    mUtility.Delay 1                'just delay, commant it out and put your code instead
    varTestResults = "133"         'put the test result to variable
    'then send test output to menu
    If Not .SendData(GroupName, "Q4 Current", varTestResults) Then DoCurrentTest = IsFailed
    '====================================================================================
    
    If mIsAbortTest Then Exit Function
    varTestResults = "Testing"
    .SendData GroupName, "Total Current", varTestResults
     '====================start your code to test this parameter here=====================
    mUtility.Delay 1                'just delay, commant it out and put your code instead
    varTestResults = "433"         'put the test result to variable
    'then send test output to menu
    If Not .SendData(GroupName, "Total Current", varTestResults) Then DoCurrentTest = IsFailed
    '====================================================================================
End With
End Function

Private Function DoGain1MHzTest(ByVal GroupName As String, _
                                Optional IsNeedPowerOn As Boolean = False) As TestResult
Dim varTestResults As Variant
'default is passed unless found any failure then set to failed
DoGain1MHzTest = IsPassed

With mTestMenu
    varTestResults = "Testing"
    .SendData GroupName, "Q1", varTestResults  'make testing hi-light
    '====================start your code to test this parameter here=====================
    mUtility.Delay 1                'just delay, commant it out and put your code instead
    '***put your code here***
    '***put your code here***
    varTestResults = "7.2"         'put the test result to variable
    'then send test output to menu
    If Not .SendData(GroupName, "Q1", varTestResults) Then DoGain1MHzTest = IsFailed
    
    If mIsAbortTest Then Exit Function
    varTestResults = "Testing"
    .SendData GroupName, "Q2", varTestResults  'make testing hi-light
     '====================start your code to test this parameter here=====================
    mUtility.Delay 1                'just delay, commant it out and put your code instead
    varTestResults = "6.8"         'put the test result to variable
    'then send test output to menu
    If Not .SendData(GroupName, "Q2", varTestResults) Then DoGain1MHzTest = IsFailed
    '====================================================================================
    
    If mIsAbortTest Then Exit Function
    varTestResults = "Testing"
    .SendData GroupName, "Q3", varTestResults
     '====================start your code to test this parameter here=====================
    mUtility.Delay 1                'just delay, commant it out and put your code instead
    varTestResults = "6.1"         'put the test result to variable
    'then send test output to menu
    If Not .SendData(GroupName, "Q3", varTestResults) Then DoGain1MHzTest = IsFailed
    '====================================================================================
    
    If mIsAbortTest Then Exit Function
    varTestResults = "Testing"
    .SendData GroupName, "Q4", varTestResults
     '====================start your code to test this parameter here=====================
    mUtility.Delay 1                'just delay, commant it out and put your code instead
    varTestResults = "7.8"         'put the test result to variable
    'then send test output to menu
    If Not .SendData(GroupName, "Q4", varTestResults) Then DoGain1MHzTest = IsFailed
    '====================================================================================
End With
End Function

Private Function DoFreqResponseTest(ByVal GroupName As String, _
                                    Optional IsNeedPowerOn As Boolean = False) As TestResult
Dim varTestResults As Variant
'default is passed unless found any failure then set to failed
DoFreqResponseTest = IsPassed

With mTestMenu
    varTestResults = "Testing"
    .SendData GroupName, "Q1 @-3dB", varTestResults  'make testing hi-light
    '====================start your code to test this parameter here=====================
    mUtility.Delay 1                'just delay, commant it out and put your code instead
    '***put your code here***
    '***put your code here***
    varTestResults = "1.77"         'put the test result to variable
    'then send test output to menu
    If Not .SendData(GroupName, "Q1 @-3dB", varTestResults) Then DoFreqResponseTest = IsFailed
    
    If mIsAbortTest Then Exit Function
    varTestResults = "Testing"
    .SendData GroupName, "Q2 @-3dB", varTestResults  'make testing hi-light
     '====================start your code to test this parameter here=====================
    mUtility.Delay 1                'just delay, commant it out and put your code instead
    varTestResults = "1.73"         'put the test result to variable
    'then send test output to menu
    If Not .SendData(GroupName, "Q2 @-3dB", varTestResults) Then DoFreqResponseTest = IsFailed
    '====================================================================================
    
    If mIsAbortTest Then Exit Function
    varTestResults = "Testing"
    .SendData GroupName, "Q3 @-3dB", varTestResults
     '====================start your code to test this parameter here=====================
    mUtility.Delay 1                'just delay, commant it out and put your code instead
    varTestResults = "1.68"         'put the test result to variable
    'then send test output to menu
    If Not .SendData(GroupName, "Q3 @-3dB", varTestResults) Then DoFreqResponseTest = IsFailed
    '====================================================================================
    
    If mIsAbortTest Then Exit Function
    varTestResults = "Testing"
    .SendData GroupName, "Q4 @-3dB", varTestResults
     '====================start your code to test this parameter here=====================
    mUtility.Delay 1                'just delay, commant it out and put your code instead
    varTestResults = "1.64"         'put the test result to variable
    'then send test output to menu
    If Not .SendData(GroupName, "Q4 @-3dB", varTestResults) Then DoFreqResponseTest = IsFailed
    '====================================================================================
End With
End Function

Private Function DoBiasVoltageTest(ByVal GroupName As String, _
                                   Optional IsNeedPowerOn As Boolean = False) As TestResult
Dim varTestResults As Variant
Dim dteTimeOut As Date
'default is passed unless found any failure then set to failed
DoBiasVoltageTest = IsPassed

With mTestMenu
    varTestResults = "Testing"
    .SendData GroupName, "Q1", varTestResults  'make testing hi-light
    '====================start your code to test this parameter here=====================
    '***put your code here***
    '***put your code here***
    'demo how to use PSLEDBar32 class
    With mBiasVoltageTune
        .CabReference = "Bias Voltage"
        .DigitColorPass = vbGreen
        .DigitColorFail = vbRed
        .DecimalPoint = 2
        .ScaleMax = mTestMenu.GetMaxSpec(GroupName, "Q1") + 0.5
        .ScaleMin = mTestMenu.GetMinSpec(GroupName, "Q1") - 0.5
        .Max = mTestMenu.GetMaxSpec(GroupName, "Q1")
        .Min = mTestMenu.GetMinSpec(GroupName, "Q1")
        .Suffix = "VDC"
        .Top = mFluke45.PanelTop + mFluke45.PanelHeight * 2
        .Left = mFluke45.PanelLeft
        .Show
    End With
    mUtility.InfoBox mstr4NewLine & "Please slide the LED bar button in your right side.", vbOKOnly
    'this one is shown use loop without event
    dteTimeOut = Now() + #12:00:05 AM#                   'set time out 5 second
    Do
        If mIsAbortTest Then Exit Function
        DoEvents
    Loop Until mBiasVoltageTune.IsPassed Or Now >= dteTimeOut
    varTestResults = mBiasVoltageTune.Value              'put the test result to variable
    mBiasVoltageTune.Done
    'then send test output to menu
    If Not .SendData(GroupName, "Q1", varTestResults) Then DoBiasVoltageTest = IsFailed
    
    varTestResults = "Testing"
    .SendData GroupName, "Q2", varTestResults  'make testing hi-light
    'demo how to use PSLEDBar32 and PSVirtualDevice32 class _
     this one is shown use event by get value from PSLEDBar32 and put to PSVirtualDevice32 _
     see event ValueChanged
    With mBiasVoltageTune
        .CabReference = "Bias Voltage"
        .DigitColorPass = vbGreen
        .DigitColorFail = vbRed
        .DecimalPoint = 3
        .PreciseStep = 0.01
        .ScaleMax = mTestMenu.GetMaxSpec(GroupName, "Q2") + 0.5
        .ScaleMin = mTestMenu.GetMinSpec(GroupName, "Q2") - 0.5
        .Max = mTestMenu.GetMaxSpec(GroupName, "Q2")
        .Min = mTestMenu.GetMinSpec(GroupName, "Q2")
        .Suffix = "VDC"
        .Top = mFluke45.PanelTop + mFluke45.PanelHeight * 2
        .Left = mFluke45.PanelLeft
        .Show
    End With
    With mVirtualDevice
        .CabReference = "My Virtual Device"
        .DigitColorPass = vbGreen
        .DigitColorFail = vbRed
        .Top = mBiasVoltageTune.Top + mBiasVoltageTune.Height
        .Left = mBiasVoltageTune.Left
        .Caption = "Untuned"
        .Max = 1.2
        .Min = 0.8
        .Suffix = "VDC"
        .Show
    End With
    'this one is shown use loop with event and no timeout
    mIsVirtualDeviceQuit = False                         'clear flag to check the click event from virtual device
    Do
        If mIsAbortTest Then Exit Function
        DoEvents
    Loop Until mIsVirtualDeviceQuit
    varTestResults = mVirtualDevice.Value                'put the test result to variable
    mBiasVoltageTune.Done
    mVirtualDevice.Done
    'then send test output to menu
    If Not .SendData(GroupName, "Q2", varTestResults) Then DoBiasVoltageTest = IsFailed
    '====================================================================================
    
    If mIsAbortTest Then Exit Function
    varTestResults = "Testing"
    .SendData GroupName, "Q3", varTestResults
     '====================start your code to test this parameter here=====================
    mUtility.Delay 1                'just delay, commant it out and put your code instead
    varTestResults = "1.33"         'put the test result to variable
    'then send test output to menu
    If Not .SendData(GroupName, "Q3", varTestResults) Then DoBiasVoltageTest = IsFailed
    '====================================================================================
    
    If mIsAbortTest Then Exit Function
    varTestResults = "Testing"
    .SendData GroupName, "Q4", varTestResults
     '====================start your code to test this parameter here=====================
    mUtility.Delay 1                'just delay, commant it out and put your code instead
    varTestResults = "1.42"         'put the test result to variable
    'then send test output to menu
    If Not .SendData(GroupName, "Q4", varTestResults) Then DoBiasVoltageTest = IsFailed
    '====================================================================================
End With
End Function

Private Function DoTempFullLoadTest(ByVal GroupName As String, _
                                    Optional IsNeedPowerOn As Boolean = False) As TestResult
Dim varTestResults As Variant
'default is passed unless found any failure then set to failed
DoTempFullLoadTest = IsPassed

With mTestMenu
    varTestResults = "Testing"
    .SendData GroupName, "Q1", varTestResults  'make testing hi-light
    '====================start your code to test this parameter here=====================
    mUtility.Delay 1                'just delay, commant it out and put your code instead
    '***put your code here***
    '***put your code here***
    varTestResults = "69"           'put the test result to variable
    'then send test output to menu
    If Not .SendData(GroupName, "Q1", varTestResults) Then DoTempFullLoadTest = IsFailed
    
    If mIsAbortTest Then Exit Function
    varTestResults = "Testing"
    .SendData GroupName, "Q2", varTestResults  'make testing hi-light
     '====================start your code to test this parameter here=====================
    mUtility.Delay 1                'just delay, commant it out and put your code instead
    varTestResults = "68.5"         'put the test result to variable
    'then send test output to menu
    If Not .SendData(GroupName, "Q2", varTestResults) Then DoTempFullLoadTest = IsFailed
    '====================================================================================
    
    If mIsAbortTest Then Exit Function
    varTestResults = "Testing"
    .SendData GroupName, "Q3", varTestResults
     '====================start your code to test this parameter here=====================
    mUtility.Delay 1                'just delay, commant it out and put your code instead
    varTestResults = "68.6"         'put the test result to variable
    'then send test output to menu
    If Not .SendData(GroupName, "Q3", varTestResults) Then DoTempFullLoadTest = IsFailed
    '====================================================================================
    
    If mIsAbortTest Then Exit Function
    varTestResults = "Testing"
    .SendData GroupName, "Q4", varTestResults
     '====================start your code to test this parameter here=====================
    mUtility.Delay 1                'just delay, commant it out and put your code instead
    varTestResults = "68.9"         'put the test result to variable
    'then send test output to menu
    If Not .SendData(GroupName, "Q4", varTestResults) Then DoTempFullLoadTest = IsFailed
    '====================================================================================
End With
End Function

Private Function DoGroupATest(ByVal GroupName As String, _
                              Optional TestOption As String) As TestResult
'RICH COMMENT
Dim varTestResults As Variant
'if you have test option before/after do this test you may use the follow code
If TestOption <> "" Then DoSomethingBeforeTest TestOption

'default is passed unless found any failure then set to failed
DoGroupATest = IsPassed

With mTestMenu
    varTestResults = "Testing"
    .SendData GroupName, "Parameter 1", varTestResults  'make testing hi-light
    '====================start your code to test this parameter here=====================
    mUtility.Delay 2                'just delay, commant it out and put your code instead
    '***put your code here***
    '***put your code here***
    'do/for/while
        'if you have long time for test loop you may need to add checking abort test as below
        'If mIsAbortTest Then GoTo StopTest
    'Loop/next/wend
    'varTestResults = mFluke45.Value 'put the test result to variable
    'also this parameter need logical value so you may need compare data like below
    'If varTestResults >= myMinValue And varTestResults <= myMaxValue Then
    '    varTestResults = "Pass"
    'Else
    '    varTestResults = "Fail"
    'End If
    varTestResults = "Pass"
    'then send test output to menu
    If Not .SendData(GroupName, "Parameter 1", varTestResults) Then
        DoGroupATest = IsFailed
        GoTo StopTest               'abort test right away if it failed (if needed)
    End If
    '====================================================================================
    
    If mIsAbortTest Then GoTo StopTest
    varTestResults = "Testing"
    .SendData GroupName, "Parameter 2", varTestResults  'make testing hi-light
     '====================start your code to test this parameter here=====================
    mUtility.Delay 2                'just delay, commant it out and put your code instead
    '***put your code here***
    'do/for/while
        'if you have long time for test loop you may need to add checking abort test as below
        'If mIsAbortTest Then GoTo StopTest
    'Loop/next/wend
    'varTestResults = mFluke45.Value 'put the test result to variable
    'also this parameter need logical value so you may need compare data like below
    'If varTestResults >= myMinValue And varTestResults <= myMaxValue Then
    '    varTestResults = "Pass"
    'Else
    '    varTestResults = "Fail"
    'End If
    varTestResults = "Pass"         'put the test result to variable
    'then send test output to menu
    If Not .SendData(GroupName, "Parameter 2", varTestResults) Then
        DoGroupATest = IsFailed     'allow continue test even found a tested failure
    End If
    '====================================================================================
    
    If mIsAbortTest Then GoTo StopTest
    varTestResults = "Testing"
    .SendData GroupName, "Parameter 3", varTestResults  'make testing hi-light
     '====================start your code to test this parameter here=====================
    mUtility.Delay 2                'just delay, commant it out and put your code instead
    '***put your code here***
    'do/for/while
        'if you have long time for test loop you may need to add checking abort test as below
        'If mIsAbortTest Then GoTo StopTest
    'Loop/next/wend
    'varTestResults = mFluke45.Value 'put the test result to variable
    'also this parameter need logical value so you may need compare data like below
    'If varTestResults >= myMinValue And varTestResults <= myMaxValue Then
    '    varTestResults = "Pass"
    'Else
    '    varTestResults = "Fail"
    'End If
    varTestResults = "Pass"         'put the test result to variable
    'then send test output to menu
    If Not .SendData(GroupName, "Parameter 3", varTestResults) Then
        DoGroupATest = IsFailed     'allow continue test even found a tested failure
    End If
    '====================================================================================
    
    If mIsAbortTest Then GoTo StopTest
    varTestResults = "Testing"
    .SendData GroupName, "Parameter 4", varTestResults  'make testing hi-light
     '====================start your code to test this parameter here=====================
    mUtility.Delay 2                'just delay, commant it out and put your code instead
    '***put your code here***
    'do/for/while
        'if you have long time for test loop you may need to add checking abort test as below
        'If mIsAbortTest Then GoTo StopTest
    'Loop/next/wend
    'varTestResults = mFluke45.Value 'put the test result to variable
    'also this parameter need logical value so you may need compare data like below
    'If varTestResults >= myMinValue And varTestResults <= myMaxValue Then
    '    varTestResults = "Pass"
    'Else
    '    varTestResults = "Fail"
    'End If
    varTestResults = "Pass"         'put the test result to variable
    'then send test output to menu
    If Not .SendData(GroupName, "Parameter 4", varTestResults) Then
        DoGroupATest = IsFailed     'allow continue test even found a tested failure
    End If
    '====================================================================================
    
    If mIsAbortTest Then GoTo StopTest
    varTestResults = "Testing"
    .SendData GroupName, "Parameter 5", varTestResults  'make testing hi-light
     '====================start your code to test this parameter here=====================
    mUtility.Delay 2                'just delay, commant it out and put your code instead
    '***put your code here***
    'do/for/while
        'if you have long time for test loop you may need to add checking abort test as below
        'If mIsAbortTest Then GoTo StopTest
    'Loop/next/wend
    'varTestResults = mFluke45.Value 'put the test result to variable
    'also this parameter need logical value so you may need compare data like below
    'If varTestResults >= myMinValue And varTestResults <= myMaxValue Then
    '    varTestResults = "Pass"
    'Else
    '    varTestResults = "Fail"
    'End If
    varTestResults = "Pass"         'put the test result to variable
    'then send test output to menu
    If Not .SendData(GroupName, "Parameter 5", varTestResults) Then
        DoGroupATest = IsFailed     'allow continue test even found a tested failure
    End If
    '====================================================================================
    
    If mIsAbortTest Then GoTo StopTest
    varTestResults = "Testing"
    .SendData GroupName, "Parameter 6", varTestResults  'make testing hi-light
     '====================start your code to test this parameter here=====================
    mUtility.Delay 2                'just delay, commant it out and put your code instead
    '***put your code here***
    'do/for/while
        'if you have long time for test loop you may need to add checking abort test as below
        'If mIsAbortTest Then GoTo StopTest
    'Loop/next/wend
    'varTestResults = mFluke45.Value 'put the test result to variable
    'also this parameter need logical value so you may need compare data like below
    'If varTestResults >= myMinValue And varTestResults <= myMaxValue Then
    '    varTestResults = "Pass"
    'Else
    '    varTestResults = "Fail"
    'End If
    varTestResults = "Pass"         'put the test result to variable
    'then send test output to menu
    If Not .SendData(GroupName, "Parameter 6", varTestResults) Then
        DoGroupATest = IsFailed     'allow continue test even found a tested failure
    End If
    '====================================================================================
    
    If mIsAbortTest Then GoTo StopTest
    varTestResults = "Testing"
    .SendData GroupName, "Parameter 7", varTestResults  'make testing hi-light
     '====================start your code to test this parameter here=====================
    mUtility.Delay 2                'just delay, commant it out and put your code instead
    '***put your code here***
    'do/for/while
        'if you have long time for test loop you may need to add checking abort test as below
        'If mIsAbortTest Then GoTo StopTest
    'Loop/next/wend
    'varTestResults = mFluke45.Value 'put the test result to variable
    'also this parameter need logical value so you may need compare data like below
    'If varTestResults >= myMinValue And varTestResults <= myMaxValue Then
    '    varTestResults = "Pass"
    'Else
    '    varTestResults = "Fail"
    'End If
    varTestResults = "Pass"         'put the test result to variable
    'then send test output to menu
    If Not .SendData(GroupName, "Parameter 7", varTestResults) Then
        DoGroupATest = IsFailed     'allow continue test even found a tested failure
    End If
    '====================================================================================
    
    If mIsAbortTest Then GoTo StopTest
    varTestResults = "Testing"
    .SendData GroupName, "Parameter 8", varTestResults  'make testing hi-light
     '====================start your code to test this parameter here=====================
    mUtility.Delay 2                'just delay, commant it out and put your code instead
    '***put your code here***
    '***put your code here***
    'do/for/while
        'if you have long time for test loop you may need to add checking abort test as below
        'If mIsAbortTest Then GoTo StopTest
    'Loop/next/wend
    'varTestResults = mFluke45.Value 'put the test result to variable
    'also this parameter need logical value so you may need compare data like below
    'If varTestResults >= myMinValue And varTestResults <= myMaxValue Then
    '    varTestResults = "Pass"
    'Else
    '    varTestResults = "Fail"
    'End If
    varTestResults = "Pass"         'put the test result to variable
    'then send test output to menu
    If Not .SendData(GroupName, "Parameter 8", varTestResults) Then
        DoGroupATest = IsFailed     'allow continue test even found a tested failure
    End If
    '====================================================================================
    
    If mIsAbortTest Then GoTo StopTest
    varTestResults = "Testing"
    .SendData GroupName, "Parameter 9", varTestResults  'make testing hi-light
     '====================start your code to test this parameter here=====================
    mUtility.Delay 2                'just delay, commant it out and put your code instead
    '***put your code here***
    'do/for/while
        'if you have long time for test loop you may need to add checking abort test as below
        'If mIsAbortTest Then GoTo StopTest
    'Loop/next/wend
    'varTestResults = mFluke45.Value 'put the test result to variable
    'also this parameter need logical value so you may need compare data like below
    'If varTestResults >= myMinValue And varTestResults <= myMaxValue Then
    '    varTestResults = "Pass"
    'Else
    '    varTestResults = "Fail"
    'End If
    varTestResults = "Pass"         'put the test result to variable
    'then send test output to menu
    If Not .SendData(GroupName, "Parameter 9", varTestResults) Then
        DoGroupATest = IsFailed     'allow continue test even found a tested failure
    End If
    '====================================================================================
    
    If mIsAbortTest Then GoTo StopTest
    varTestResults = "Testing"
    .SendData GroupName, "Parameter 10", varTestResults  'make testing hi-light
     '====================start your code to test this parameter here=====================
    mUtility.Delay 2                'just delay, commant it out and put your code instead
    '***put your code here***
    'do/for/while
        'if you have long time for test loop you may need to add checking abort test as below
        'If mIsAbortTest Then GoTo StopTest
    'Loop/next/wend
    'varTestResults = mFluke45.Value 'put the test result to variable
    'also this parameter need logical value so you may need compare data like below
    'If varTestResults >= myMinValue And varTestResults <= myMaxValue Then
    '    varTestResults = "Pass"
    'Else
    '    varTestResults = "Fail"
    'End If
    varTestResults = "Pass"         'put the test result to variable
    'then send test output to menu
    If Not .SendData(GroupName, "Parameter 10", varTestResults) Then
        DoGroupATest = IsFailed     'allow continue test even found a tested failure
    End If
End With
If TestOption <> "" Then DoSomethingAfterTest
On Error GoTo 0
Exit Function

StopTest:
varTestResults = "Fail"         'any incomplete test then force test result to be failed
On Error GoTo 0

'if you have test option before/after do this test you may use the follow code
If TestOption <> "" Then DoSomethingAfterTest
End Function

Private Function DoGroupBTest(ByVal GroupName As String, _
                              Optional TestOption As String) As TestResult
'LESS COMMENT
Dim varTestResults As Variant
If TestOption <> "" Then DoSomethingBeforeTest TestOption

DoGroupBTest = IsPassed

With mTestMenu
    varTestResults = "Testing"
    .SendData GroupName, "Parameter 1", varTestResults  'make testing hi-light
    mUtility.Delay 2                'just delay, commant it out and put your code instead
    '***put your code here***
    'this unit is milli so you may need to multiply by 1000 before send to test menu
    'varTestResults = Format(mFluke45.Value * 1000, "#,##0.00") 'put the test result to variable
    varTestResults = 125
    If Not .SendData(GroupName, "Parameter 1", varTestResults) Then
        DoGroupBTest = IsFailed
    End If
    
    If mIsAbortTest Then GoTo StopTest
    varTestResults = "Testing"
    .SendData GroupName, "Parameter 2", varTestResults  'make testing hi-light
    mUtility.Delay 2                'just delay, commant it out and put your code instead
    '***put your code here***
    varTestResults = 115            'put the test result to variable
    If Not .SendData(GroupName, "Parameter 2", varTestResults) Then
        DoGroupBTest = IsFailed    'allow continue test even found a tested failure
    End If
    
    If mIsAbortTest Then GoTo StopTest
    varTestResults = "Testing"
    .SendData GroupName, "Parameter 3", varTestResults  'make testing hi-light
    mUtility.Delay 2                'just delay, commant it out and put your code instead
    '***put your code here***
    varTestResults = 105            'put the test result to variable
    If Not .SendData(GroupName, "Parameter 3", varTestResults) Then
        DoGroupBTest = IsFailed    'allow continue test even found a tested failure
    End If
    
    If mIsAbortTest Then GoTo StopTest
    varTestResults = "Testing"
    .SendData GroupName, "Parameter 4", varTestResults  'make testing hi-light
    mUtility.Delay 2                'just delay, commant it out and put your code instead
    '***put your code here***
    varTestResults = 145            'put the test result to variable
    If Not .SendData(GroupName, "Parameter 4", varTestResults) Then
        DoGroupBTest = IsFailed    'allow continue test even found a tested failure
    End If
    
    If mIsAbortTest Then GoTo StopTest
    varTestResults = "Testing"
    .SendData GroupName, "Parameter 5", varTestResults  'make testing hi-light
    mUtility.Delay 2                'just delay, commant it out and put your code instead
    '***put your code here***
    varTestResults = 209            'put the test result to variable
    If Not .SendData(GroupName, "Parameter 5", varTestResults) Then
        DoGroupBTest = IsFailed    'allow continue test even found a tested failure
    End If
    
    If mIsAbortTest Then GoTo StopTest
    varTestResults = "Testing"
    .SendData GroupName, "Parameter 6", varTestResults  'make testing hi-light
    mUtility.Delay 2                'just delay, commant it out and put your code instead
    '***put your code here***
    varTestResults = 12             'put the test result to variable
    If Not .SendData(GroupName, "Parameter 6", varTestResults) Then
        DoGroupBTest = IsFailed    'allow continue test even found a tested failure
    End If
    
    If mIsAbortTest Then GoTo StopTest
    varTestResults = "Testing"
    .SendData GroupName, "Parameter 7", varTestResults  'make testing hi-light
    mUtility.Delay 2                'just delay, commant it out and put your code instead
    '***put your code here***
    varTestResults = 22.56          'put the test result to variable
    If Not .SendData(GroupName, "Parameter 7", varTestResults) Then
        DoGroupBTest = IsFailed    'allow continue test even found a tested failure
    End If
    
    If mIsAbortTest Then GoTo StopTest
    varTestResults = "Testing"
    .SendData GroupName, "Parameter 8", varTestResults  'make testing hi-light
    mUtility.Delay 2                'just delay, commant it out and put your code instead
    '***put your code here***
    varTestResults = 448.5          'put the test result to variable
    If Not .SendData(GroupName, "Parameter 8", varTestResults) Then
        DoGroupBTest = IsFailed    'allow continue test even found a tested failure
    End If
    
    If mIsAbortTest Then GoTo StopTest
    varTestResults = "Testing"
    .SendData GroupName, "Parameter 9", varTestResults  'make testing hi-light
    mUtility.Delay 2                'just delay, commant it out and put your code instead
    '***put your code here***
    varTestResults = 449.1          'put the test result to variable
    If Not .SendData(GroupName, "Parameter 9", varTestResults) Then
        DoGroupBTest = IsFailed    'allow continue test even found a tested failure
    End If
    
    If mIsAbortTest Then GoTo StopTest
    varTestResults = "Testing"
    .SendData GroupName, "Parameter 10", varTestResults  'make testing hi-light
    mUtility.Delay 2                'just delay, commant it out and put your code instead
    '***put your code here***
    varTestResults = 509            'put the test result to variable
    If Not .SendData(GroupName, "Parameter 10", varTestResults) Then
        DoGroupBTest = IsFailed    'allow continue test even found a tested failure
    End If
End With
If TestOption <> "" Then DoSomethingAfterTest
On Error GoTo 0
Exit Function

StopTest:
varTestResults = "Fail"         'any incomplete test then force test result to be failed
On Error GoTo 0

If TestOption <> "" Then DoSomethingAfterTest
End Function

Private Sub DoBackInitialState()
'add your code here also this procedure should include shutdown all power suppy (get to safe state)
With mE3631A
    .InitCommand1 = "APPL 0,0;OUTPOFF"
    .Execute
End With
With m3499A
    .InitCommand1 = "*RST;*CLS"
    .InitCommand2 = ":DISP:INFO ""COMPANY X"""    'open all switches
    .Execute
End With
End Sub

Private Sub DoTurnOnPower(Optional ByVal VDC_Output As Single = 0, _
                          Optional ByVal CurrLmt As Single = 0)
With mE3631A
    .InitCommand1 = "APPL VDC_Output,CurrLmt;OUTPON"
    .Execute
End With
End Sub

Private Sub DoSomethingBeforeTest(Optional ByVal TestOption As String)
'add your code here
Select Case TestOption
    Case "Set_Ohm"
        With mFluke45
            .InitCommand1 = "*RST;*CLS"
            .InitCommand2 = "OHMS;RATE F"
            .PanelOption = "OHM"
            .ReadCommand = "MEAS?"
            .ReadInterval = 300
            .Execute
        End With
    Case "Set_Curr"
        With mFluke45
            .InitCommand1 = "*RST;*CLS"
            .InitCommand2 = "ADC;RATE F"
            .PanelOption = "ADC"
            .ReadCommand = "MEAS?"
            .ReadInterval = 100
            .Execute
        End With
    Case "Set_Volt"
        With mFluke45
            .InitCommand1 = "*RST;*CLS"
            .InitCommand2 = "VDC;RATE F"
            .PanelOption = "VDC"
            .ReadCommand = "MEAS?"
            .ReadInterval = 250
            .Execute
        End With
End Select
End Sub

Private Sub DoSomethingAfterTest(Optional ByVal TestOption As String)
'add your code here
mFluke45.ReadInterval = 0       'stop read from device
mFluke45.Execute
End Sub

Private Function DoGroupCTest(ByVal GroupName As String, _
                              Optional TestOption As String) As TestResult
'LESS COMMENT
Dim varTestResults As Variant
If TestOption <> "" Then DoSomethingBeforeTest TestOption

DoGroupCTest = IsPassed

With mTestMenu
    varTestResults = "Testing"
    .SendData GroupName, "Parameter 1", varTestResults  'make testing hi-light
    mUtility.Delay 2                'just delay, commant it out and put your code instead
    '***put your code here***
    varTestResults = -4
    If Not .SendData(GroupName, "Parameter 1", varTestResults) Then
        DoGroupCTest = IsFailed
    End If
    
    If mIsAbortTest Then GoTo StopTest
    varTestResults = "Testing"
    .SendData GroupName, "Parameter 2", varTestResults  'make testing hi-light
    mUtility.Delay 2                'just delay, commant it out and put your code instead
    '***put your code here***
    varTestResults = -1             'put the test result to variable
    If Not .SendData(GroupName, "Parameter 2", varTestResults) Then
        DoGroupCTest = IsFailed    'allow continue test even found a tested failure
    End If
    
    If mIsAbortTest Then GoTo StopTest
    varTestResults = "Testing"
    .SendData GroupName, "Parameter 3", varTestResults  'make testing hi-light
    mUtility.Delay 2                'just delay, commant it out and put your code instead
    '***put your code here***
    varTestResults = -5              'put the test result to variable
    If Not .SendData(GroupName, "Parameter 3", varTestResults) Then
        DoGroupCTest = IsFailed    'allow continue test even found a tested failure
    End If
    
    If mIsAbortTest Then GoTo StopTest
    varTestResults = "Testing"
    .SendData GroupName, "Parameter 4", varTestResults  'make testing hi-light
    mUtility.Delay 2                'just delay, commant it out and put your code instead
    '***put your code here***
    varTestResults = -9             'put the test result to variable
    If Not .SendData(GroupName, "Parameter 4", varTestResults) Then
        DoGroupCTest = IsFailed    'allow continue test even found a tested failure
    End If
    
    If mIsAbortTest Then GoTo StopTest
    varTestResults = "Testing"
    .SendData GroupName, "Parameter 5", varTestResults  'make testing hi-light
    mUtility.Delay 2                'just delay, commant it out and put your code instead
    '***put your code here***
    varTestResults = 42.5           'put the test result to variable
    If Not .SendData(GroupName, "Parameter 5", varTestResults) Then
        DoGroupCTest = IsFailed    'allow continue test even found a tested failure
    End If
    
    If mIsAbortTest Then GoTo StopTest
    varTestResults = "Testing"
    .SendData GroupName, "Parameter 6", varTestResults  'make testing hi-light
    mUtility.Delay 2                'just delay, commant it out and put your code instead
    '***put your code here***
    varTestResults = 53             'put the test result to variable
    If Not .SendData(GroupName, "Parameter 6", varTestResults) Then
        DoGroupCTest = IsFailed    'allow continue test even found a tested failure
    End If
    
    If mIsAbortTest Then GoTo StopTest
    varTestResults = "Testing"
    .SendData GroupName, "Parameter 7", varTestResults  'make testing hi-light
    mUtility.Delay 2                'just delay, commant it out and put your code instead
    '***put your code here***
    varTestResults = 22.56          'put the test result to variable
    If Not .SendData(GroupName, "Parameter 7", varTestResults) Then
        DoGroupCTest = IsFailed    'allow continue test even found a tested failure
    End If
    
    If mIsAbortTest Then GoTo StopTest
    varTestResults = "Testing"
    .SendData GroupName, "Parameter 8", varTestResults  'make testing hi-light
    mUtility.Delay 2                'just delay, commant it out and put your code instead
    '***put your code here***
    varTestResults = -19            'put the test result to variable
    If Not .SendData(GroupName, "Parameter 8", varTestResults) Then
        DoGroupCTest = IsFailed    'allow continue test even found a tested failure
    End If
    
    If mIsAbortTest Then GoTo StopTest
    varTestResults = "Testing"
    .SendData GroupName, "Parameter 9", varTestResults  'make testing hi-light
    mUtility.Delay 2                'just delay, commant it out and put your code instead
    '***put your code here***
    varTestResults = 8.5            'put the test result to variable
    If Not .SendData(GroupName, "Parameter 9", varTestResults) Then
        DoGroupCTest = IsFailed    'allow continue test even found a tested failure
    End If
    
    If mIsAbortTest Then GoTo StopTest
    varTestResults = "Testing"
    .SendData GroupName, "Parameter 10", varTestResults  'make testing hi-light
    mUtility.Delay 2                'just delay, commant it out and put your code instead
    '***put your code here***
    varTestResults = 7              'put the test result to variable
    If Not .SendData(GroupName, "Parameter 10", varTestResults) Then
        DoGroupCTest = IsFailed    'allow continue test even found a tested failure
    End If
End With
If TestOption <> "" Then DoSomethingAfterTest
On Error GoTo 0
Exit Function

StopTest:
varTestResults = "Fail"         'any incomplete test then force test result to be failed
On Error GoTo 0

If TestOption <> "" Then DoSomethingAfterTest
End Function

Private Function DoGroupDTest(ByVal GroupName As String, _
                              Optional TestOption As String) As TestResult
'LESS COMMENT
Dim varTestResults As Variant
If TestOption <> "" Then DoSomethingBeforeTest TestOption

DoGroupDTest = IsPassed

With mTestMenu
    varTestResults = "Testing"
    .SendData GroupName, "Parameter 1", varTestResults  'make testing hi-light
    mUtility.Delay 2                'just delay, commant it out and put your code instead
    '***put your code here***
    'this unit is kilo so you may need to divide by 1000 before send to test menu
    'varTestResults = Format(m53131A.Value * 0.001, "#,##0.00") 'put the test result to variable
    varTestResults = 0.8
    If Not .SendData(GroupName, "Parameter 1", varTestResults) Then
        DoGroupDTest = IsFailed
    End If
    
    If mIsAbortTest Then GoTo StopTest
    varTestResults = "Testing"
    .SendData GroupName, "Parameter 2", varTestResults  'make testing hi-light
    mUtility.Delay 2                'just delay, commant it out and put your code instead
    '***put your code here***
    varTestResults = 1.2            'put the test result to variable
    If Not .SendData(GroupName, "Parameter 2", varTestResults) Then
        DoGroupDTest = IsFailed    'allow continue test even found a tested failure
    End If
    
    If mIsAbortTest Then GoTo StopTest
    varTestResults = "Testing"
    .SendData GroupName, "Parameter 3", varTestResults  'make testing hi-light
    mUtility.Delay 2                'just delay, commant it out and put your code instead
    '***put your code here***
    varTestResults = 3              'put the test result to variable
    If Not .SendData(GroupName, "Parameter 3", varTestResults) Then
        DoGroupDTest = IsFailed    'allow continue test even found a tested failure
    End If
    
    If mIsAbortTest Then GoTo StopTest
    varTestResults = "Testing"
    .SendData GroupName, "Parameter 4", varTestResults  'make testing hi-light
    mUtility.Delay 2                'just delay, commant it out and put your code instead
    '***put your code here***
    varTestResults = 1.6            'put the test result to variable
    If Not .SendData(GroupName, "Parameter 4", varTestResults) Then
        DoGroupDTest = IsFailed     'allow continue test even found a tested failure
    End If
    
    If mIsAbortTest Then GoTo StopTest
    varTestResults = "Testing"
    .SendData GroupName, "Parameter 5", varTestResults  'make testing hi-light
    mUtility.Delay 2                'just delay, commant it out and put your code instead
    '***put your code here***
    varTestResults = 5              'put the test result to variable
    If Not .SendData(GroupName, "Parameter 5", varTestResults) Then
        DoGroupDTest = IsFailed    'allow continue test even found a tested failure
    End If
End With
If TestOption <> "" Then DoSomethingAfterTest
On Error GoTo 0
Exit Function

StopTest:
varTestResults = "Fail"         'any incomplete test then force test result to be failed
On Error GoTo 0

If TestOption <> "" Then DoSomethingAfterTest
End Function

Private Function DoGroupETest(ByVal GroupName As String, _
                              Optional TestOption As String) As TestResult
'LESS COMMENT
Dim varTestResults As Variant
If TestOption <> "" Then DoSomethingBeforeTest TestOption

DoGroupETest = IsPassed

With mTestMenu
    varTestResults = "Testing"
    .SendData GroupName, "Parameter 1", varTestResults  'make testing hi-light
    mUtility.Delay 2                'just delay, commant it out and put your code instead
    '***put your code here***
    'this unit is celsius unit so you may need covert from mV to Celsius by you formular
    'varTestResults = Format(mfluke45.Value  * myFormular, "##0.00") 'put the test result to variable
    varTestResults = 62
    If Not .SendData(GroupName, "Parameter 1", varTestResults) Then
        DoGroupETest = IsFailed
    End If
    
    If mIsAbortTest Then GoTo StopTest
    varTestResults = "Testing"
    .SendData GroupName, "Parameter 2", varTestResults  'make testing hi-light
    mUtility.Delay 2                'just delay, commant it out and put your code instead
    '***put your code here***
    varTestResults = 66             'put the test result to variable
    If Not .SendData(GroupName, "Parameter 2", varTestResults) Then
        DoGroupETest = IsFailed    'allow continue test even found a tested failure
    End If
    
    If mIsAbortTest Then GoTo StopTest
    varTestResults = "Testing"
    .SendData GroupName, "Parameter 3", varTestResults  'make testing hi-light
    mUtility.Delay 2                'just delay, commant it out and put your code instead
    '***put your code here***
    varTestResults = 63.5              'put the test result to variable
    If Not .SendData(GroupName, "Parameter 3", varTestResults) Then
        DoGroupETest = IsFailed    'allow continue test even found a tested failure
    End If
    
    If mIsAbortTest Then GoTo StopTest
    varTestResults = "Testing"
    .SendData GroupName, "Parameter 4", varTestResults  'make testing hi-light
    mUtility.Delay 2                'just delay, commant it out and put your code instead
    '***put your code here***
    varTestResults = 67.5           'put the test result to variable
    If Not .SendData(GroupName, "Parameter 4", varTestResults) Then
        DoGroupETest = IsFailed     'allow continue test even found a tested failure
    End If
    
    If mIsAbortTest Then GoTo StopTest
    varTestResults = "Testing"
    .SendData GroupName, "Parameter 5", varTestResults  'make testing hi-light
    mUtility.Delay 2                'just delay, commant it out and put your code instead
    '***put your code here***
    varTestResults = 65             'put the test result to variable
    If Not .SendData(GroupName, "Parameter 5", varTestResults) Then
        DoGroupETest = IsFailed    'allow continue test even found a tested failure
    End If
End With
If TestOption <> "" Then DoSomethingAfterTest
On Error GoTo 0
Exit Function

StopTest:
varTestResults = "Fail"         'any incomplete test then force test result to be failed
On Error GoTo 0

If TestOption <> "" Then DoSomethingAfterTest
End Function

Private Function DoGroupFTest(ByVal GroupName As String, _
                              Optional TestOption As String) As TestResult
'LESS COMMENT
Dim varTestResults As Variant
If TestOption <> "" Then DoSomethingBeforeTest TestOption

DoGroupFTest = IsPassed

With mTestMenu
    varTestResults = "Testing"
    .SendData GroupName, "Parameter 1", varTestResults  'make testing hi-light
    mUtility.Delay 2                 'just delay, commant it out and put your code instead
    '***put your code here***
    'varTestResults = Format(mfluke45.Value, "##0.00") 'put the test result to variable
    varTestResults = 1.2
    If Not .SendData(GroupName, "Parameter 1", varTestResults) Then
        DoGroupFTest = IsFailed
    End If
    
    If mIsAbortTest Then GoTo StopTest
    varTestResults = "Testing"
    .SendData GroupName, "Parameter 2", varTestResults  'make testing hi-light
    mUtility.Delay 2                'just delay, commant it out and put your code instead
    '***put your code here***
    varTestResults = 1.3            'put the test result to variable
    If Not .SendData(GroupName, "Parameter 2", varTestResults) Then
        DoGroupFTest = IsFailed     'allow continue test even found a tested failure
    End If
    
    If mIsAbortTest Then GoTo StopTest
    varTestResults = "Testing"
    .SendData GroupName, "Parameter 3", varTestResults  'make testing hi-light
    mUtility.Delay 2                'just delay, commant it out and put your code instead
    '***put your code here***
    varTestResults = 2.99           'put the test result to variable
    If Not .SendData(GroupName, "Parameter 3", varTestResults) Then
        DoGroupFTest = IsFailed     'allow continue test even found a tested failure
    End If
    
    If mIsAbortTest Then GoTo StopTest
    varTestResults = "Testing"
    .SendData GroupName, "Parameter 4", varTestResults  'make testing hi-light
    mUtility.Delay 2                'just delay, commant it out and put your code instead
    '***put your code here***
    varTestResults = 2.45           'put the test result to variable
    If Not .SendData(GroupName, "Parameter 4", varTestResults) Then
        DoGroupFTest = IsFailed     'allow continue test even found a tested failure
    End If
    
    If mIsAbortTest Then GoTo StopTest
    varTestResults = "Testing"
    .SendData GroupName, "Parameter 5", varTestResults  'make testing hi-light
    mUtility.Delay 2                'just delay, commant it out and put your code instead
    '***put your code here***
    varTestResults = 3.34           'put the test result to variable
    If Not .SendData(GroupName, "Parameter 5", varTestResults) Then
        DoGroupFTest = IsFailed    'allow continue test even found a tested failure
    End If
End With
If TestOption <> "" Then DoSomethingAfterTest
On Error GoTo 0
Exit Function

StopTest:
varTestResults = "Fail"         'any incomplete test then force test result to be failed
On Error GoTo 0

If TestOption <> "" Then DoSomethingAfterTest
End Function

Private Function DoGroupGTest(ByVal GroupName As String, _
                              Optional TestOption As String) As TestResult
'LESS COMMENT
Dim varTestResults As Variant
If TestOption <> "" Then DoSomethingBeforeTest TestOption

DoGroupGTest = IsPassed

With mTestMenu
    varTestResults = "Testing"
    .SendData GroupName, "Parameter 1", varTestResults  'make testing hi-light
    mUtility.Delay 2                 'just delay, commant it out and put your code instead
    '***put your code here***
    varTestResults = 74
    If Not .SendData(GroupName, "Parameter 1", varTestResults) Then
        DoGroupGTest = IsFailed
    End If
    
    If mIsAbortTest Then GoTo StopTest
    varTestResults = "Testing"
    .SendData GroupName, "Parameter 2", varTestResults  'make testing hi-light
    mUtility.Delay 2                'just delay, commant it out and put your code instead
    '***put your code here***
    varTestResults = 73.5          'put the test result to variable
    If Not .SendData(GroupName, "Parameter 2", varTestResults) Then
        DoGroupGTest = IsFailed     'allow continue test even found a tested failure
    End If
    
    If mIsAbortTest Then GoTo StopTest
    varTestResults = "Testing"
    .SendData GroupName, "Parameter 3", varTestResults  'make testing hi-light
    mUtility.Delay 2                'just delay, commant it out and put your code instead
    '***put your code here***
    varTestResults = 72.5           'put the test result to variable
    If Not .SendData(GroupName, "Parameter 3", varTestResults) Then
        DoGroupGTest = IsFailed     'allow continue test even found a tested failure
    End If
    
    If mIsAbortTest Then GoTo StopTest
    varTestResults = "Testing"
    .SendData GroupName, "Parameter 4", varTestResults  'make testing hi-light
    mUtility.Delay 2                'just delay, commant it out and put your code instead
    '***put your code here***
    varTestResults = 75             'put the test result to variable
    If Not .SendData(GroupName, "Parameter 4", varTestResults) Then
        DoGroupGTest = IsFailed     'allow continue test even found a tested failure
    End If
    
    If mIsAbortTest Then GoTo StopTest
    varTestResults = "Testing"
    .SendData GroupName, "Parameter 5", varTestResults  'make testing hi-light
    mUtility.Delay 2                'just delay, commant it out and put your code instead
    '***put your code here***
    varTestResults = 74             'put the test result to variable
    If Not .SendData(GroupName, "Parameter 5", varTestResults) Then
        DoGroupGTest = IsFailed     'allow continue test even found a tested failure
    End If

    If mIsAbortTest Then GoTo StopTest
    varTestResults = "Testing"
    .SendData GroupName, "Parameter 6", varTestResults  'make testing hi-light
    mUtility.Delay 2                'just delay, commant it out and put your code instead
    '***put your code here***
    varTestResults = 101            'put the test result to variable
    If Not .SendData(GroupName, "Parameter 6", varTestResults) Then
        DoGroupGTest = IsFailed     'allow continue test even found a tested failure
    End If

    If mIsAbortTest Then GoTo StopTest
    varTestResults = "Testing"
    .SendData GroupName, "Parameter 7", varTestResults  'make testing hi-light
    mUtility.Delay 2                'just delay, commant it out and put your code instead
    '***put your code here***
    varTestResults = 134            'put the test result to variable
    If Not .SendData(GroupName, "Parameter 7", varTestResults) Then
        DoGroupGTest = IsFailed     'allow continue test even found a tested failure
    End If

    If mIsAbortTest Then GoTo StopTest
    varTestResults = "Testing"
    .SendData GroupName, "Parameter 8", varTestResults  'make testing hi-light
    mUtility.Delay 2                'just delay, commant it out and put your code instead
    '***put your code here***
    varTestResults = 209            'put the test result to variable
    If Not .SendData(GroupName, "Parameter 8", varTestResults) Then
        DoGroupGTest = IsFailed     'allow continue test even found a tested failure
    End If

    If mIsAbortTest Then GoTo StopTest
    varTestResults = "Testing"
    .SendData GroupName, "Parameter 9", varTestResults  'make testing hi-light
    mUtility.Delay 2                'just delay, commant it out and put your code instead
    '***put your code here***
    varTestResults = 2.21           'put the test result to variable
    If Not .SendData(GroupName, "Parameter 9", varTestResults) Then
        DoGroupGTest = IsFailed     'allow continue test even found a tested failure
    End If

    If mIsAbortTest Then GoTo StopTest
    varTestResults = "Testing"
    .SendData GroupName, "Parameter 10", varTestResults  'make testing hi-light
    mUtility.Delay 2                'just delay, commant it out and put your code instead
    '***put your code here***
    varTestResults = 3.33           'put the test result to variable
    If Not .SendData(GroupName, "Parameter 10", varTestResults) Then
        DoGroupGTest = IsFailed     'allow continue test even found a tested failure
    End If

End With
If TestOption <> "" Then DoSomethingAfterTest
On Error GoTo 0
Exit Function

StopTest:
varTestResults = "Fail"         'any incomplete test then force test result to be failed
On Error GoTo 0

If TestOption <> "" Then DoSomethingAfterTest
End Function

Private Sub mTestMenu_LogoDoubleClick()
mTestMenu.ShowCabinet
End Sub

Private Sub mTestMenu_PrintClick()
mReport.PrintReport
End Sub

Private Sub mVirtualDevice_CancelClick(ByVal SentValue As Double, ByVal IsPassed As Boolean)
mIsVirtualDeviceQuit = True
End Sub

Private Sub mVirtualDevice_OKClick(ByVal SentValue As Double, ByVal IsPassed As Boolean)
mIsVirtualDeviceQuit = True
End Sub
